<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        // set instance object
        self::instance($this); 
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        if ($this->template->security && isset($this->smarty->security_handler)) {
              $this->sec_obj = $this->smarty->security_policy;
        } else {
              $this->sec_obj = $this->smarty;
        }
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
				$this->block_nesting_level = 0;
				$this->is_xml = false;
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }

    public static function escape_start_tag($tag_text) {
       $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
       assert($tag !== false && $count === 1);
       return $tag;
    }

    public static function escape_end_tag($tag_text) {
       assert($tag_text === '?>');
       return '?<?php ?>>';
    }

    
#line 128 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_FAKEPHPSTARTTAG                =  6;
    const TP_XMLTAG                         =  7;
    const TP_OTHER                          =  8;
    const TP_LITERALSTART                   =  9;
    const TP_LITERALEND                     = 10;
    const TP_LITERAL                        = 11;
    const TP_LDEL                           = 12;
    const TP_RDEL                           = 13;
    const TP_DOLLAR                         = 14;
    const TP_ID                             = 15;
    const TP_EQUAL                          = 16;
    const TP_PTR                            = 17;
    const TP_LDELIF                         = 18;
    const TP_SPACE                          = 19;
    const TP_LDELFOR                        = 20;
    const TP_SEMICOLON                      = 21;
    const TP_INCDEC                         = 22;
    const TP_TO                             = 23;
    const TP_STEP                           = 24;
    const TP_LDELFOREACH                    = 25;
    const TP_AS                             = 26;
    const TP_APTR                           = 27;
    const TP_LDELSLASH                      = 28;
    const TP_INTEGER                        = 29;
    const TP_COMMA                          = 30;
    const TP_MATH                           = 31;
    const TP_UNIMATH                        = 32;
    const TP_ANDSYM                         = 33;
    const TP_ISIN                           = 34;
    const TP_ISDIVBY                        = 35;
    const TP_ISNOTDIVBY                     = 36;
    const TP_ISEVEN                         = 37;
    const TP_ISNOTEVEN                      = 38;
    const TP_ISEVENBY                       = 39;
    const TP_ISNOTEVENBY                    = 40;
    const TP_ISODD                          = 41;
    const TP_ISNOTODD                       = 42;
    const TP_ISODDBY                        = 43;
    const TP_ISNOTODDBY                     = 44;
    const TP_INSTANCEOF                     = 45;
    const TP_OPENP                          = 46;
    const TP_CLOSEP                         = 47;
    const TP_QMARK                          = 48;
    const TP_NOT                            = 49;
    const TP_TYPECAST                       = 50;
    const TP_HEX                            = 51;
    const TP_DOT                            = 52;
    const TP_SINGLEQUOTESTRING              = 53;
    const TP_DOUBLECOLON                    = 54;
    const TP_AT                             = 55;
    const TP_HATCH                          = 56;
    const TP_OPENB                          = 57;
    const TP_CLOSEB                         = 58;
    const TP_EQUALS                         = 59;
    const TP_NOTEQUALS                      = 60;
    const TP_GREATERTHAN                    = 61;
    const TP_LESSTHAN                       = 62;
    const TP_GREATEREQUAL                   = 63;
    const TP_LESSEQUAL                      = 64;
    const TP_IDENTITY                       = 65;
    const TP_NONEIDENTITY                   = 66;
    const TP_MOD                            = 67;
    const TP_LAND                           = 68;
    const TP_LOR                            = 69;
    const TP_LXOR                           = 70;
    const TP_QUOTE                          = 71;
    const TP_BACKTICK                       = 72;
    const TP_DOLLARID                       = 73;
    const YY_NO_ACTION = 546;
    const YY_ACCEPT_ACTION = 545;
    const YY_ERROR_ACTION = 544;

    const YY_SZ_ACTTAB = 2037;
static public $yy_action = array(
 /*     0 */   175,  239,  238,  246,  248,  235,  234,  230,  266,  273,
 /*    10 */   158,  223,  291,    7,   29,  170,   12,  290,  179,  205,
 /*    20 */    13,  202,  200,  179,  114,    5,  124,  117,  233,  192,
 /*    30 */    42,   43,   45,   40,   21,   22,  281,  299,   26,   27,
 /*    40 */   278,  256,   31,   30,  263,  279,  251,   35,    8,  158,
 /*    50 */   265,  271,  545,   83,  241,  238,  246,  136,  306,  307,
 /*    60 */   308,  305,  304,  301,  302,  303,  309,  310,  316,  317,
 /*    70 */   175,  315,  289,  175,  132,  268,  113,  219,  179,  166,
 /*    80 */   105,  152,  296,  221,  175,  319,  168,  284,  179,  206,
 /*    90 */   128,  179,  358,  351,  284,  314,  331,  216,  183,  110,
 /*   100 */    42,   43,   45,   40,   21,   22,  281,  299,   26,   27,
 /*   110 */   278,  256,   31,   30,   42,   43,   45,   40,   21,   22,
 /*   120 */   281,  299,   26,   27,  278,  256,   31,   30,  306,  307,
 /*   130 */   308,  305,  304,  301,  302,  303,  309,  310,  316,  317,
 /*   140 */   175,    4,  306,  307,  308,  305,  304,  301,  302,  303,
 /*   150 */   309,  310,  316,  317,  175,   33,   32,  311,  179,  346,
 /*   160 */    17,   32,  348,   38,  346,  345,  253,  156,  343,  338,
 /*   170 */    42,   43,   45,   40,   21,   22,  281,  299,   26,   27,
 /*   180 */   278,  256,   31,   30,   42,   43,   45,   40,   21,   22,
 /*   190 */   281,  299,   26,   27,  278,  256,   31,   30,  306,  307,
 /*   200 */   308,  305,  304,  301,  302,  303,  309,  310,  316,  317,
 /*   210 */   175,  212,  306,  307,  308,  305,  304,  301,  302,  303,
 /*   220 */   309,  310,  316,  317,  175,  220,   32,  259,  179,  346,
 /*   230 */    32,  157,  343,  346,   34,  146,  252,  347,  107,  203,
 /*   240 */    42,   43,   45,   40,   21,   22,  281,  299,   26,   27,
 /*   250 */   278,  256,   31,   30,   42,   43,   45,   40,   21,   22,
 /*   260 */   281,  299,   26,   27,  278,  256,   31,   30,  306,  307,
 /*   270 */   308,  305,  304,  301,  302,  303,  309,  310,  316,  317,
 /*   280 */    87,  323,  306,  307,  308,  305,  304,  301,  302,  303,
 /*   290 */   309,  310,  316,  317,  175,  315,  153,  201,  347,  222,
 /*   300 */   122,  219,   53,  119,  105,  283,  164,   36,  175,  103,
 /*   310 */   137,  179,  318,  165,  288,  314,  358,  351,  262,  314,
 /*   320 */   258,  189,   24,   23,   42,   43,   45,   40,   21,   22,
 /*   330 */   281,  299,   26,   27,  278,  256,   31,   30,   42,   43,
 /*   340 */    45,   40,   21,   22,  281,  299,   26,   27,  278,  256,
 /*   350 */    31,   30,  306,  307,  308,  305,  304,  301,  302,  303,
 /*   360 */   309,  310,  316,  317,  175,  225,  306,  307,  308,  305,
 /*   370 */   304,  301,  302,  303,  309,  310,  316,  317,  175,  414,
 /*   380 */   320,  282,  199,  298,  162,  179,  179,  179,  288,  179,
 /*   390 */   229,  161,  343,  347,   42,   43,   45,   40,   21,   22,
 /*   400 */   281,  299,   26,   27,  278,  256,   31,   30,   42,   43,
 /*   410 */    45,   40,   21,   22,  281,  299,   26,   27,  278,  256,
 /*   420 */    31,   30,  306,  307,  308,  305,  304,  301,  302,  303,
 /*   430 */   309,  310,  316,  317,    2,  128,  306,  307,  308,  305,
 /*   440 */   304,  301,  302,  303,  309,  310,  316,  317,  175,  315,
 /*   450 */   154,  175,   86,  100,  155,   98,   52,  121,   99,  159,
 /*   460 */   167,   32,  260,  357,  346,  128,  318,  196,  288,  179,
 /*   470 */   358,  351,  102,  314,   32,  240,  187,  346,   42,   43,
 /*   480 */    45,   40,   21,   22,  281,  299,   26,   27,  278,  256,
 /*   490 */    31,   30,  175,  194,   32,  116,   12,  346,   34,   32,
 /*   500 */   170,   20,  346,  280,  114,   13,  306,  307,  308,  305,
 /*   510 */   304,  301,  302,  303,  309,  310,  316,  317,  321,   46,
 /*   520 */   191,  217,   42,   43,   45,   40,   21,   22,  281,  299,
 /*   530 */    26,   27,  278,  256,   31,   30,  175,  224,  250,  328,
 /*   540 */    32,   32,  224,  346,  214,   25,  175,  104,  243,  280,
 /*   550 */   306,  307,  308,  305,  304,  301,  302,  303,  309,  310,
 /*   560 */   316,  317,  261,   15,  179,  297,   42,   43,   45,   40,
 /*   570 */    21,   22,  281,  299,   26,   27,  278,  256,   31,   30,
 /*   580 */   175,  295,   12,  209,   93,  330,   32,  179,   32,  211,
 /*   590 */   114,  182,  269,  134,  306,  307,  308,  305,  304,  301,
 /*   600 */   302,  303,  309,  310,  316,  317,  284,  324,  347,  292,
 /*   610 */    42,   43,   45,   40,   21,   22,  281,  299,   26,   27,
 /*   620 */   278,  256,   31,   30,  175,  342,  293,   12,  339,  247,
 /*   630 */   228,  179,  179,  179,  179,  114,  179,  149,  306,  307,
 /*   640 */   308,  305,  304,  301,  302,  303,  309,  310,  316,  317,
 /*   650 */   284,  109,   39,    3,   42,   43,   45,   40,   21,   22,
 /*   660 */   281,  299,   26,   27,  278,  256,   31,   30,  175,  356,
 /*   670 */   349,  355,  341,  352,  236,  179,  179,  179,  179,  179,
 /*   680 */   179,  294,  306,  307,  308,  305,  304,  301,  302,  303,
 /*   690 */   309,  310,  316,  317,   46,  336,  111,  267,   42,   43,
 /*   700 */    45,   40,   21,   22,  281,  299,   26,   27,  278,  256,
 /*   710 */    31,   30,  175,   46,  213,  354,  245,  350,  277,  128,
 /*   720 */   288,   11,   41,    9,  120,  139,  306,  307,  308,  305,
 /*   730 */   304,  301,  302,  303,  309,  310,  316,  317,  284,  179,
 /*   740 */   221,  223,   42,   43,   45,   40,   21,   22,  281,  299,
 /*   750 */    26,   27,  278,  256,   31,   30,  102,  415,    8,  255,
 /*   760 */   207,  417,   14,  415,  198,   37,  353,  417,  333,  143,
 /*   770 */   306,  307,  308,  305,  304,  301,  302,  303,  309,  310,
 /*   780 */   316,  317,  284,    7,  232,  115,  169,  226,  315,  205,
 /*   790 */    12,  202,  222,   46,  219,   59,  124,  105,  114,  192,
 /*   800 */   215,   32,  344,   44,  346,  318,  130,  325,   35,  358,
 /*   810 */   351,  270,  314,  147,  120,   10,  195,   16,  237,  208,
 /*   820 */    48,   47,  313,  204,  340,   97,  284,   87,    1,  227,
 /*   830 */     7,  249,  112,   85,  123,  150,  205,  237,  202,  141,
 /*   840 */   285,  329,   84,  124,  126,    6,  192,  215,  284,  244,
 /*   850 */    44,  205,  284,  202,   90,  179,  237,  188,  124,  142,
 /*   860 */   148,  192,  285,   88,   28,  163,  285,   48,   47,  313,
 /*   870 */   204,  340,  284,  284,   87,    1,   96,    7,  315,  115,
 /*   880 */   178,   46,  186,  205,  219,  202,  131,  105,  237,   84,
 /*   890 */   124,   95,  312,  192,  215,  190,  106,   44,  237,  358,
 /*   900 */   351,  125,  314,  237,  327,   18,  322,  140,  237,   19,
 /*   910 */   275,   16,  264,  237,   48,   47,  313,  204,  340,    9,
 /*   920 */   284,   87,    1,   41,    7,  345,  115,  178,   94,  458,
 /*   930 */   205,  127,  202,  254,  129,  329,   84,  124,  285,    6,
 /*   940 */   192,  215,   89,  237,   44,  205,  237,  202,  138,   12,
 /*   950 */    91,   92,  124,  144,  301,  192,  197,  114,   28,  160,
 /*   960 */   301,   48,   47,  313,  204,  340,  301,  301,   87,    1,
 /*   970 */   301,    7,  315,  115,  174,  301,  337,  205,  219,  202,
 /*   980 */   301,  105,  301,   84,  124,  301,  301,  192,  215,  332,
 /*   990 */   301,   44,  301,  358,  351,  301,  314,  301,  326,   18,
 /*  1000 */   322,  301,  301,  301,  301,   16,  301,  301,   48,   47,
 /*  1010 */   313,  204,  340,  301,  301,   87,    1,  301,    7,  315,
 /*  1020 */   107,  172,  301,  276,  205,  219,  202,  301,  105,  301,
 /*  1030 */    84,  124,  301,  301,  192,  180,  274,  301,   44,  301,
 /*  1040 */   358,  351,  301,  314,  301,  301,  301,  301,  301,  301,
 /*  1050 */   301,  301,   16,  301,  301,   48,   47,  313,  204,  340,
 /*  1060 */   301,  301,   87,    1,  301,    7,  315,  107,  178,  301,
 /*  1070 */   257,  205,  219,  202,  301,  105,  301,   84,  124,  301,
 /*  1080 */   301,  192,  215,  301,  301,   44,  301,  358,  351,  301,
 /*  1090 */   314,  301,  301,  301,  301,  301,  301,  301,  301,   16,
 /*  1100 */   301,  301,   48,   47,  313,  204,  340,  301,  301,   87,
 /*  1110 */     1,  301,    7,  315,  108,  178,  301,  231,  205,  219,
 /*  1120 */   202,  301,  105,  301,   84,  124,  301,  301,  192,  215,
 /*  1130 */   301,  301,   44,  301,  358,  351,  301,  314,  301,  301,
 /*  1140 */   301,  301,  301,  301,  301,  301,   16,  301,  301,   48,
 /*  1150 */    47,  313,  204,  340,  301,  301,   87,    1,  301,    7,
 /*  1160 */   315,  115,  171,  301,  286,  205,  219,  202,  301,  105,
 /*  1170 */   301,   84,  124,  301,  301,  192,  215,  301,  301,   44,
 /*  1180 */   301,  358,  351,  301,  314,  301,  301,  301,  301,  301,
 /*  1190 */   301,  301,  301,   28,  301,  301,   48,   47,  313,  204,
 /*  1200 */   340,  301,  301,   87,    1,  301,    7,  315,  107,  178,
 /*  1210 */   301,  300,  205,  219,  202,  301,  105,  301,   84,  124,
 /*  1220 */   301,  301,  192,  215,  301,  301,   44,  301,  358,  351,
 /*  1230 */   315,  314,  301,  301,  287,  301,  219,  301,  301,  105,
 /*  1240 */    16,  301,  301,   48,   47,  313,  204,  340,  301,  301,
 /*  1250 */    87,  358,  351,    7,  314,  107,  176,  301,  301,  205,
 /*  1260 */   301,  202,  301,  133,  301,   84,  124,  301,  165,  192,
 /*  1270 */   215,  301,  301,   44,  301,  301,  284,   24,   23,  315,
 /*  1280 */   301,  301,  301,  177,  301,  219,   82,   16,  105,  301,
 /*  1290 */    48,   47,  313,  204,  340,  301,  318,   87,  315,  301,
 /*  1300 */   358,  351,  177,  314,  219,   82,  301,  105,  301,  301,
 /*  1310 */   301,  301,   84,  335,  301,  318,  301,  301,  301,  358,
 /*  1320 */   351,  301,  314,  301,  301,  301,  301,  301,  301,  315,
 /*  1330 */   301,  184,  334,  100,  301,  101,   51,  121,   99,  301,
 /*  1340 */   301,  301,  301,  301,  301,  301,  318,  301,  315,  301,
 /*  1350 */   358,  351,  181,  314,  219,   49,  118,  105,  301,  301,
 /*  1360 */   301,  301,  301,  301,  301,  318,  301,  315,  301,  358,
 /*  1370 */   351,  173,  314,  219,   71,  242,  105,  301,  301,  301,
 /*  1380 */   301,  301,  301,  301,  318,  301,  315,  301,  358,  351,
 /*  1390 */   222,  314,  219,   59,  301,  105,  301,  301,  301,  301,
 /*  1400 */   301,  301,  301,  318,  301,  301,  301,  358,  351,  301,
 /*  1410 */   314,  301,  315,  301,  301,  301,  222,  193,  219,   56,
 /*  1420 */   301,  105,  301,  301,  218,  301,  301,  301,  301,  318,
 /*  1430 */   301,  315,  301,  358,  351,  222,  314,  219,   59,  301,
 /*  1440 */   105,  301,  301,  301,  301,  301,  301,  301,  318,  301,
 /*  1450 */   315,  301,  358,  351,  222,  314,  219,   59,  301,  105,
 /*  1460 */   301,  301,  210,  301,  301,  301,  301,  318,  301,  315,
 /*  1470 */   301,  358,  351,  222,  314,  219,   77,  301,  105,  301,
 /*  1480 */   301,  359,  301,  301,  301,  301,  318,  301,  301,  301,
 /*  1490 */   358,  351,  145,  314,  301,  315,  301,  165,  301,  222,
 /*  1500 */   301,  219,   81,  301,  105,  284,   24,   23,  301,  301,
 /*  1510 */   301,  301,  318,  301,  315,  301,  358,  351,  222,  314,
 /*  1520 */   219,   62,  301,  105,  301,  301,  301,  301,  301,  301,
 /*  1530 */   301,  318,  301,  315,  301,  358,  351,  222,  314,  219,
 /*  1540 */    54,  301,  105,  301,  301,  301,  301,  301,  301,  301,
 /*  1550 */   318,  301,  315,  301,  358,  351,  222,  314,  219,   79,
 /*  1560 */   301,  105,  301,  301,  301,  301,  301,  301,  301,  318,
 /*  1570 */   301,  301,  301,  358,  351,  135,  314,  301,  315,  301,
 /*  1580 */   165,  301,  222,  301,  219,   60,  301,  105,  284,   24,
 /*  1590 */    23,  301,  301,  301,  301,  318,  301,  315,  301,  358,
 /*  1600 */   351,  222,  314,  219,   65,  301,  105,  301,  301,  301,
 /*  1610 */   301,  301,  301,  301,  318,  301,  315,  301,  358,  351,
 /*  1620 */   222,  314,  219,   55,  301,  105,  301,  301,  301,  301,
 /*  1630 */   301,  301,  301,  318,  301,  315,  301,  358,  351,  222,
 /*  1640 */   314,  219,   58,  301,  105,  301,  301,  301,  301,  301,
 /*  1650 */   301,  301,  318,  301,  301,  301,  358,  351,  151,  314,
 /*  1660 */   301,  315,  301,  165,  301,  222,  301,  219,   75,  301,
 /*  1670 */   105,  284,   24,   23,  301,  301,  301,  301,  318,  301,
 /*  1680 */   315,  301,  358,  351,  222,  314,  219,   63,  301,  105,
 /*  1690 */   301,  301,  301,  301,  301,  301,  301,  318,  301,  315,
 /*  1700 */   301,  358,  351,  222,  314,  219,   72,  301,  105,  301,
 /*  1710 */   301,  301,  301,  301,  301,  301,  318,  301,  315,  301,
 /*  1720 */   358,  351,  222,  314,  219,   69,  301,  105,  301,  301,
 /*  1730 */   301,  301,  301,  301,  301,  318,  301,  301,  301,  358,
 /*  1740 */   351,  301,  314,  301,  315,  301,  301,  301,  222,  301,
 /*  1750 */   185,   61,  301,  105,  301,  301,  301,  301,  301,  301,
 /*  1760 */   301,  318,  301,  315,  301,  358,  351,  222,  314,  219,
 /*  1770 */    67,  301,  105,  301,  301,  301,  301,  301,  301,  301,
 /*  1780 */   318,  301,  315,  301,  358,  351,  222,  314,  219,   74,
 /*  1790 */   301,  105,  301,  301,  301,  301,  301,  301,  301,  318,
 /*  1800 */   301,  315,  301,  358,  351,  222,  314,  219,   80,  301,
 /*  1810 */   105,  301,  301,  301,  301,  301,  301,  301,  318,  301,
 /*  1820 */   301,  301,  358,  351,  301,  314,  301,  315,  301,  301,
 /*  1830 */   301,  222,  301,  219,   66,  301,  105,  301,  301,  301,
 /*  1840 */   301,  301,  301,  301,  318,  301,  315,  301,  358,  351,
 /*  1850 */   222,  314,  219,   70,  301,  105,  301,  301,  301,  301,
 /*  1860 */   301,  301,  301,  318,  301,  315,  301,  358,  351,  222,
 /*  1870 */   314,  219,   76,  301,  105,  301,  301,  301,  301,  301,
 /*  1880 */   301,  301,  318,  301,  315,  301,  358,  351,  222,  314,
 /*  1890 */   219,   64,  301,  105,  301,  301,  301,  301,  301,  301,
 /*  1900 */   301,  318,  301,  301,  301,  358,  351,  301,  314,  301,
 /*  1910 */   315,  301,  301,  301,  222,  301,  219,   57,  301,  105,
 /*  1920 */   301,  301,  301,  301,  301,  301,  301,  318,  301,  315,
 /*  1930 */   301,  358,  351,  222,  314,  219,   50,  301,  105,  301,
 /*  1940 */   301,  301,  301,  301,  301,  301,  318,  301,  315,  301,
 /*  1950 */   358,  351,  222,  314,  219,   78,  301,  105,  301,  301,
 /*  1960 */   301,  301,  301,  301,  301,  318,  301,  315,  301,  358,
 /*  1970 */   351,  222,  314,  219,   68,  301,  105,  301,  301,  301,
 /*  1980 */   301,  301,  301,  301,  318,  301,  301,  301,  358,  351,
 /*  1990 */   301,  314,  301,  315,  301,  301,  301,  222,  301,  219,
 /*  2000 */    73,  301,  105,  301,  301,  301,  301,  301,  301,  301,
 /*  2010 */   318,  301,  315,  301,  358,  351,  272,  314,  219,  301,
 /*  2020 */   301,  105,  301,  301,  301,  301,  301,  301,  301,  301,
 /*  2030 */   301,  301,  301,  358,  351,  301,  314,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,   77,   78,   79,    3,    4,    5,    6,    7,    8,
 /*    10 */     9,    2,   13,   12,   12,   52,   46,   13,   19,   18,
 /*    20 */    57,   20,   52,   19,   54,   16,   25,   14,   58,   28,
 /*    30 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*    40 */    41,   42,   43,   44,    4,    5,    6,   16,   46,    9,
 /*    50 */    10,   11,   75,   76,   77,   78,   79,  103,   59,   60,
 /*    60 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */     1,   78,   13,    1,   83,   82,   14,   84,   19,   88,
 /*    80 */    87,   83,   13,   52,    1,   13,   88,   96,   19,   17,
 /*    90 */    17,   19,   99,  100,   96,  102,   13,   90,   91,   14,
 /*   100 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*   110 */    41,   42,   43,   44,   31,   32,   33,   34,   35,   36,
 /*   120 */    37,   38,   39,   40,   41,   42,   43,   44,   59,   60,
 /*   130 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   140 */     1,   30,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   150 */    67,   68,   69,   70,    1,    2,   12,   15,   19,   15,
 /*   160 */    16,   12,   13,   24,   15,  104,   22,  106,  107,   58,
 /*   170 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*   180 */    41,   42,   43,   44,   31,   32,   33,   34,   35,   36,
 /*   190 */    37,   38,   39,   40,   41,   42,   43,   44,   59,   60,
 /*   200 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   210 */     1,   15,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   220 */    67,   68,   69,   70,    1,   29,   12,   13,   19,   15,
 /*   230 */    12,  106,  107,   15,   16,  103,   13,  105,   14,   15,
 /*   240 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*   250 */    41,   42,   43,   44,   31,   32,   33,   34,   35,   36,
 /*   260 */    37,   38,   39,   40,   41,   42,   43,   44,   59,   60,
 /*   270 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   280 */    56,   15,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   290 */    67,   68,   69,   70,    1,   78,  103,   84,  105,   82,
 /*   300 */    87,   84,   85,   86,   87,   13,   13,   12,    1,   14,
 /*   310 */    15,   19,   95,   88,   22,  102,   99,  100,   79,  102,
 /*   320 */    81,   55,   97,   98,   31,   32,   33,   34,   35,   36,
 /*   330 */    37,   38,   39,   40,   41,   42,   43,   44,   31,   32,
 /*   340 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   350 */    43,   44,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   360 */    67,   68,   69,   70,    1,   58,   59,   60,   61,   62,
 /*   370 */    63,   64,   65,   66,   67,   68,   69,   70,    1,   13,
 /*   380 */    13,   13,   94,   13,   21,   19,   19,   19,   22,   19,
 /*   390 */    13,  106,  107,  105,   31,   32,   33,   34,   35,   36,
 /*   400 */    37,   38,   39,   40,   41,   42,   43,   44,   31,   32,
 /*   410 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   420 */    43,   44,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   430 */    67,   68,   69,   70,   16,   17,   59,   60,   61,   62,
 /*   440 */    63,   64,   65,   66,   67,   68,   69,   70,    1,   78,
 /*   450 */    21,    1,   15,   82,   15,   84,   85,   86,   87,   30,
 /*   460 */    13,   12,   13,   13,   15,   17,   95,   17,   22,   19,
 /*   470 */    99,  100,   54,  102,   12,   47,   27,   15,   31,   32,
 /*   480 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   490 */    43,   44,    1,   26,   12,   14,   46,   15,   16,   12,
 /*   500 */    52,   27,   15,   78,   54,   57,   59,   60,   61,   62,
 /*   510 */    63,   64,   65,   66,   67,   68,   69,   70,   72,   45,
 /*   520 */    14,   15,   31,   32,   33,   34,   35,   36,   37,   38,
 /*   530 */    39,   40,   41,   42,   43,   44,    1,   55,   47,  114,
 /*   540 */    12,   12,   55,   15,   15,   12,    1,   14,   15,   78,
 /*   550 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   560 */    69,   70,   29,   27,   19,   15,   31,   32,   33,   34,
 /*   570 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   580 */     1,   13,   46,   55,  113,  114,   12,   19,   12,   15,
 /*   590 */    54,   15,   13,   83,   59,   60,   61,   62,   63,   64,
 /*   600 */    65,   66,   67,   68,   69,   70,   96,   72,  105,   15,
 /*   610 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*   620 */    41,   42,   43,   44,    1,   13,   13,   46,   13,  108,
 /*   630 */    13,   19,   19,   19,   19,   54,   19,   83,   59,   60,
 /*   640 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   650 */    96,   14,   19,   30,   31,   32,   33,   34,   35,   36,
 /*   660 */    37,   38,   39,   40,   41,   42,   43,   44,    1,   13,
 /*   670 */    13,   13,   13,   13,   13,   19,   19,   19,   19,   19,
 /*   680 */    19,   13,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   690 */    67,   68,   69,   70,   45,   29,   14,   47,   31,   32,
 /*   700 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   710 */    43,   44,    1,   45,   47,   15,   13,  101,   47,   17,
 /*   720 */    22,   46,    2,   16,  108,   83,   59,   60,   61,   62,
 /*   730 */    63,   64,   65,   66,   67,   68,   69,   70,   96,   19,
 /*   740 */    52,    2,   31,   32,   33,   34,   35,   36,   37,   38,
 /*   750 */    39,   40,   41,   42,   43,   44,   54,   13,   46,   13,
 /*   760 */    15,   13,   48,   19,   15,   23,   13,   19,   96,   83,
 /*   770 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   780 */    69,   70,   96,   12,   58,   14,   15,   56,   78,   18,
 /*   790 */    46,   20,   82,   45,   84,   85,   25,   87,   54,   28,
 /*   800 */    29,   12,   13,   32,   15,   95,   93,  101,   16,   99,
 /*   810 */   100,   29,  102,   83,  108,   19,   27,   46,  105,  109,
 /*   820 */    49,   50,   51,   52,   53,   93,   96,   56,   57,   58,
 /*   830 */    12,   56,   14,   15,   19,   83,   18,  105,   20,   83,
 /*   840 */   110,    8,   71,   25,   93,   12,   28,   29,   96,   13,
 /*   850 */    32,   18,   96,   20,   15,   19,  105,   26,   25,   83,
 /*   860 */    83,   28,  110,  103,   46,   88,  110,   49,   50,   51,
 /*   870 */    52,   53,   96,   96,   56,   57,   93,   12,   78,   14,
 /*   880 */    15,   45,   82,   18,   84,   20,   93,   87,  105,   71,
 /*   890 */    25,   93,  107,   28,   29,   95,   93,   32,  105,   99,
 /*   900 */   100,   93,  102,  105,   71,   72,   73,   83,  105,   92,
 /*   910 */    10,   46,   90,  105,   49,   50,   51,   52,   53,   16,
 /*   920 */    96,   56,   57,    2,   12,  104,   14,   15,   80,   26,
 /*   930 */    18,   93,   20,   19,   93,    8,   71,   25,  110,   12,
 /*   940 */    28,   29,   89,  105,   32,   18,  105,   20,  103,   46,
 /*   950 */    89,   89,   25,  103,  115,   28,   92,   54,   46,   89,
 /*   960 */   115,   49,   50,   51,   52,   53,  115,  115,   56,   57,
 /*   970 */   115,   12,   78,   14,   15,  115,   82,   18,   84,   20,
 /*   980 */   115,   87,  115,   71,   25,  115,  115,   28,   29,   95,
 /*   990 */   115,   32,  115,   99,  100,  115,  102,  115,   71,   72,
 /*  1000 */    73,  115,  115,  115,  115,   46,  115,  115,   49,   50,
 /*  1010 */    51,   52,   53,  115,  115,   56,   57,  115,   12,   78,
 /*  1020 */    14,   15,  115,   82,   18,   84,   20,  115,   87,  115,
 /*  1030 */    71,   25,  115,  115,   28,   29,   95,  115,   32,  115,
 /*  1040 */    99,  100,  115,  102,  115,  115,  115,  115,  115,  115,
 /*  1050 */   115,  115,   46,  115,  115,   49,   50,   51,   52,   53,
 /*  1060 */   115,  115,   56,   57,  115,   12,   78,   14,   15,  115,
 /*  1070 */    82,   18,   84,   20,  115,   87,  115,   71,   25,  115,
 /*  1080 */   115,   28,   29,  115,  115,   32,  115,   99,  100,  115,
 /*  1090 */   102,  115,  115,  115,  115,  115,  115,  115,  115,   46,
 /*  1100 */   115,  115,   49,   50,   51,   52,   53,  115,  115,   56,
 /*  1110 */    57,  115,   12,   78,   14,   15,  115,   82,   18,   84,
 /*  1120 */    20,  115,   87,  115,   71,   25,  115,  115,   28,   29,
 /*  1130 */   115,  115,   32,  115,   99,  100,  115,  102,  115,  115,
 /*  1140 */   115,  115,  115,  115,  115,  115,   46,  115,  115,   49,
 /*  1150 */    50,   51,   52,   53,  115,  115,   56,   57,  115,   12,
 /*  1160 */    78,   14,   15,  115,   82,   18,   84,   20,  115,   87,
 /*  1170 */   115,   71,   25,  115,  115,   28,   29,  115,  115,   32,
 /*  1180 */   115,   99,  100,  115,  102,  115,  115,  115,  115,  115,
 /*  1190 */   115,  115,  115,   46,  115,  115,   49,   50,   51,   52,
 /*  1200 */    53,  115,  115,   56,   57,  115,   12,   78,   14,   15,
 /*  1210 */   115,   82,   18,   84,   20,  115,   87,  115,   71,   25,
 /*  1220 */   115,  115,   28,   29,  115,  115,   32,  115,   99,  100,
 /*  1230 */    78,  102,  115,  115,   82,  115,   84,  115,  115,   87,
 /*  1240 */    46,  115,  115,   49,   50,   51,   52,   53,  115,  115,
 /*  1250 */    56,   99,  100,   12,  102,   14,   15,  115,  115,   18,
 /*  1260 */   115,   20,  115,   83,  115,   71,   25,  115,   88,   28,
 /*  1270 */    29,  115,  115,   32,  115,  115,   96,   97,   98,   78,
 /*  1280 */   115,  115,  115,   82,  115,   84,   85,   46,   87,  115,
 /*  1290 */    49,   50,   51,   52,   53,  115,   95,   56,   78,  115,
 /*  1300 */    99,  100,   82,  102,   84,   85,  115,   87,  115,  115,
 /*  1310 */   115,  115,   71,  112,  115,   95,  115,  115,  115,   99,
 /*  1320 */   100,  115,  102,  115,  115,  115,  115,  115,  115,   78,
 /*  1330 */   115,  111,  112,   82,  115,   84,   85,   86,   87,  115,
 /*  1340 */   115,  115,  115,  115,  115,  115,   95,  115,   78,  115,
 /*  1350 */    99,  100,   82,  102,   84,   85,   86,   87,  115,  115,
 /*  1360 */   115,  115,  115,  115,  115,   95,  115,   78,  115,   99,
 /*  1370 */   100,   82,  102,   84,   85,   86,   87,  115,  115,  115,
 /*  1380 */   115,  115,  115,  115,   95,  115,   78,  115,   99,  100,
 /*  1390 */    82,  102,   84,   85,  115,   87,  115,  115,  115,  115,
 /*  1400 */   115,  115,  115,   95,  115,  115,  115,   99,  100,  115,
 /*  1410 */   102,  115,   78,  115,  115,  115,   82,  109,   84,   85,
 /*  1420 */   115,   87,  115,  115,   90,  115,  115,  115,  115,   95,
 /*  1430 */   115,   78,  115,   99,  100,   82,  102,   84,   85,  115,
 /*  1440 */    87,  115,  115,  115,  115,  115,  115,  115,   95,  115,
 /*  1450 */    78,  115,   99,  100,   82,  102,   84,   85,  115,   87,
 /*  1460 */   115,  115,  109,  115,  115,  115,  115,   95,  115,   78,
 /*  1470 */   115,   99,  100,   82,  102,   84,   85,  115,   87,  115,
 /*  1480 */   115,  109,  115,  115,  115,  115,   95,  115,  115,  115,
 /*  1490 */    99,  100,   83,  102,  115,   78,  115,   88,  115,   82,
 /*  1500 */   115,   84,   85,  115,   87,   96,   97,   98,  115,  115,
 /*  1510 */   115,  115,   95,  115,   78,  115,   99,  100,   82,  102,
 /*  1520 */    84,   85,  115,   87,  115,  115,  115,  115,  115,  115,
 /*  1530 */   115,   95,  115,   78,  115,   99,  100,   82,  102,   84,
 /*  1540 */    85,  115,   87,  115,  115,  115,  115,  115,  115,  115,
 /*  1550 */    95,  115,   78,  115,   99,  100,   82,  102,   84,   85,
 /*  1560 */   115,   87,  115,  115,  115,  115,  115,  115,  115,   95,
 /*  1570 */   115,  115,  115,   99,  100,   83,  102,  115,   78,  115,
 /*  1580 */    88,  115,   82,  115,   84,   85,  115,   87,   96,   97,
 /*  1590 */    98,  115,  115,  115,  115,   95,  115,   78,  115,   99,
 /*  1600 */   100,   82,  102,   84,   85,  115,   87,  115,  115,  115,
 /*  1610 */   115,  115,  115,  115,   95,  115,   78,  115,   99,  100,
 /*  1620 */    82,  102,   84,   85,  115,   87,  115,  115,  115,  115,
 /*  1630 */   115,  115,  115,   95,  115,   78,  115,   99,  100,   82,
 /*  1640 */   102,   84,   85,  115,   87,  115,  115,  115,  115,  115,
 /*  1650 */   115,  115,   95,  115,  115,  115,   99,  100,   83,  102,
 /*  1660 */   115,   78,  115,   88,  115,   82,  115,   84,   85,  115,
 /*  1670 */    87,   96,   97,   98,  115,  115,  115,  115,   95,  115,
 /*  1680 */    78,  115,   99,  100,   82,  102,   84,   85,  115,   87,
 /*  1690 */   115,  115,  115,  115,  115,  115,  115,   95,  115,   78,
 /*  1700 */   115,   99,  100,   82,  102,   84,   85,  115,   87,  115,
 /*  1710 */   115,  115,  115,  115,  115,  115,   95,  115,   78,  115,
 /*  1720 */    99,  100,   82,  102,   84,   85,  115,   87,  115,  115,
 /*  1730 */   115,  115,  115,  115,  115,   95,  115,  115,  115,   99,
 /*  1740 */   100,  115,  102,  115,   78,  115,  115,  115,   82,  115,
 /*  1750 */    84,   85,  115,   87,  115,  115,  115,  115,  115,  115,
 /*  1760 */   115,   95,  115,   78,  115,   99,  100,   82,  102,   84,
 /*  1770 */    85,  115,   87,  115,  115,  115,  115,  115,  115,  115,
 /*  1780 */    95,  115,   78,  115,   99,  100,   82,  102,   84,   85,
 /*  1790 */   115,   87,  115,  115,  115,  115,  115,  115,  115,   95,
 /*  1800 */   115,   78,  115,   99,  100,   82,  102,   84,   85,  115,
 /*  1810 */    87,  115,  115,  115,  115,  115,  115,  115,   95,  115,
 /*  1820 */   115,  115,   99,  100,  115,  102,  115,   78,  115,  115,
 /*  1830 */   115,   82,  115,   84,   85,  115,   87,  115,  115,  115,
 /*  1840 */   115,  115,  115,  115,   95,  115,   78,  115,   99,  100,
 /*  1850 */    82,  102,   84,   85,  115,   87,  115,  115,  115,  115,
 /*  1860 */   115,  115,  115,   95,  115,   78,  115,   99,  100,   82,
 /*  1870 */   102,   84,   85,  115,   87,  115,  115,  115,  115,  115,
 /*  1880 */   115,  115,   95,  115,   78,  115,   99,  100,   82,  102,
 /*  1890 */    84,   85,  115,   87,  115,  115,  115,  115,  115,  115,
 /*  1900 */   115,   95,  115,  115,  115,   99,  100,  115,  102,  115,
 /*  1910 */    78,  115,  115,  115,   82,  115,   84,   85,  115,   87,
 /*  1920 */   115,  115,  115,  115,  115,  115,  115,   95,  115,   78,
 /*  1930 */   115,   99,  100,   82,  102,   84,   85,  115,   87,  115,
 /*  1940 */   115,  115,  115,  115,  115,  115,   95,  115,   78,  115,
 /*  1950 */    99,  100,   82,  102,   84,   85,  115,   87,  115,  115,
 /*  1960 */   115,  115,  115,  115,  115,   95,  115,   78,  115,   99,
 /*  1970 */   100,   82,  102,   84,   85,  115,   87,  115,  115,  115,
 /*  1980 */   115,  115,  115,  115,   95,  115,  115,  115,   99,  100,
 /*  1990 */   115,  102,  115,   78,  115,  115,  115,   82,  115,   84,
 /*  2000 */    85,  115,   87,  115,  115,  115,  115,  115,  115,  115,
 /*  2010 */    95,  115,   78,  115,   99,  100,   82,  102,   84,  115,
 /*  2020 */   115,   87,  115,  115,  115,  115,  115,  115,  115,  115,
 /*  2030 */   115,  115,  115,   99,  100,  115,  102,
);
    const YY_SHIFT_USE_DFLT = -38;
    const YY_SHIFT_MAX = 224;
    static public $yy_shift_ofst = array(
 /*     0 */     1,  959,  912,  865,  959,  912,  818,  818,  865, 1147,
 /*    10 */  1100,  865,  865,  771,  865,  865,  865,  865,  865,  865,
 /*    20 */   865,  865,  865,  865,  865,  865,  865,  865,  865,  865,
 /*    30 */   865,  865,  865,  865,  865,  865,  865,  865,  865, 1006,
 /*    40 */  1053, 1053, 1194, 1194, 1194, 1194, 1241, 1194, 1194,   -1,
 /*    50 */   139,   69,  209,  209,  293,  153,   83,  223,  307,  623,
 /*    60 */   667,  535,  579,  491,  447,  363,  377,  711,  711,  711,
 /*    70 */   711,  711,  711,  711,  711,  711,  711,  711,  711,  711,
 /*    80 */   711,  711,  711,    1,  927,  450,   72,  224,  448,  720,
 /*    90 */   545,  720,  720,  833,   40,  482,  144,  487,  366,  418,
 /*   100 */   836,  292,  506,  574,  462,  702,  462,  462,  529,  462,
 /*   110 */   462,  462,  576,  462,  506,  529,  462,  462,  614,  614,
 /*   120 */    73,  614,   73,  481,  633,  449,  789,  218,  295,  214,
 /*   130 */   528,  149,  568,  613,  370,    4,  -37,    2,  -37,  368,
 /*   140 */   367,   59,  612,  661,  -37,  617,  -37,  615,  656,  657,
 /*   150 */   660,  659,  658,  -37,  914,  675,   73,   73,  900,  481,
 /*   160 */   921,   73,  914,  -38,  -38,  -38,  -38,  -38,  -38,  -30,
 /*   170 */   533,  744,  903,  748,  536,  266,  581,  474,  581,  196,
 /*   180 */    31,  668,    9,  429,  111,  446,  831,   13,   85,  142,
 /*   190 */   467,  439,  437,  428,   62,  637,  839,  682,  726,  753,
 /*   200 */   749,  731,  815,  775,  782,  796,  745,  746,  671,  700,
 /*   210 */   650,  675,  707,  714,  739,  688,  742,  712,  703,  698,
 /*   220 */   792,  666,  649,  550,  594,
);
    const YY_REDUCE_USE_DFLT = -77;
    const YY_REDUCE_MAX = 168;
    static public $yy_reduce_ofst = array(
 /*     0 */   -23, 1220,  217, 1372, 1201, 1270, 1251,  371,  710, 1289,
 /*    10 */  1334, 1308, 1353, 1557, 1538, 1583, 1602, 1685, 1666, 1519,
 /*    20 */  1640, 1621, 1704, 1417, 1391, 1436, 1474, 1723, 1500, 1455,
 /*    30 */  1889, 1915, 1832, 1870, 1787, 1768, 1806, 1851, 1749,  800,
 /*    40 */   894,  941, 1035,  988, 1152,   -7, 1934, 1129, 1082, 1180,
 /*    50 */  1409, 1492, 1492, 1575,  225,  225,  225,  225,  225,  225,
 /*    60 */   225,  225,  225,  225,  225,  225,  225,  225,  225,  225,
 /*    70 */   225,  225,  225,  225,  225,  225,  225,  225,  225,  225,
 /*    80 */   225,  225,  225,  -76,  471,  777,   -9,  213,   61,  730,
 /*    90 */    -2,  756,  752,  425,  239,  193,  288,  193,  642,  285,
 /*   100 */   686,  642,  616,  803,  713,  285,  132,  732,  798,  793,
 /*   110 */   751,  783,  732,  808,  706,  732,  838,  841,  824,  776,
 /*   120 */   125,  510,  285,    7,  554,  503,  503,  503,  521,  503,
 /*   130 */   503,  503,  672,  672,  672,  672,  821,  -46,  821,  672,
 /*   140 */   672,  672,  672,  672,  821,  672,  821,  672,  672,  672,
 /*   150 */   672,  672,  672,  821,  817,  760,  785,  785,  848,  822,
 /*   160 */   828,  785,  864,  853,  845,  870,  861,  850,  862,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 12, 18, 20, 25, 28, ),
        /* 1 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 2 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 3 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 4 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 5 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 6 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 7 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 8 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 9 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 10 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 11 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 12 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 13 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 58, 71, ),
        /* 14 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 15 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 16 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 17 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 18 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 19 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 20 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 21 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 22 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 23 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 24 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 25 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 26 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 27 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 28 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 29 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 30 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 31 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 32 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 33 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 34 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 35 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 36 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 37 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 38 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 39 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 40 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 41 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 57, 71, ),
        /* 42 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 71, ),
        /* 43 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 71, ),
        /* 44 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 71, ),
        /* 45 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 71, ),
        /* 46 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 71, ),
        /* 47 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 71, ),
        /* 48 */ array(12, 14, 15, 18, 20, 25, 28, 29, 32, 46, 49, 50, 51, 52, 53, 56, 71, ),
        /* 49 */ array(1, 13, 19, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 50 */ array(1, 19, 24, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 51 */ array(1, 13, 19, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 52 */ array(1, 19, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 53 */ array(1, 19, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 54 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 55 */ array(1, 2, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 56 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 57 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 58 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 59 */ array(1, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 60 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 47, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 61 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 72, ),
        /* 62 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 63 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 47, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 64 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 65 */ array(1, 21, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 66 */ array(1, 13, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 67 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 68 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 69 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 70 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 71 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 72 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 73 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 74 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 75 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 76 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 77 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 78 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 79 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 80 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 81 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 82 */ array(1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, ),
        /* 83 */ array(3, 4, 5, 6, 7, 8, 9, 12, 18, 20, 25, 28, ),
        /* 84 */ array(8, 12, 18, 20, 25, 28, 71, 72, 73, ),
        /* 85 */ array(1, 13, 17, 19, 46, 54, ),
        /* 86 */ array(1, 13, 17, 19, ),
        /* 87 */ array(14, 15, 56, ),
        /* 88 */ array(17, 52, 57, ),
        /* 89 */ array(2, 19, ),
        /* 90 */ array(1, 19, ),
        /* 91 */ array(2, 19, ),
        /* 92 */ array(2, 19, ),
        /* 93 */ array(8, 12, 18, 20, 25, 28, 71, 72, 73, ),
        /* 94 */ array(4, 5, 6, 9, 10, 11, ),
        /* 95 */ array(12, 15, 16, 55, ),
        /* 96 */ array(12, 15, 16, 22, ),
        /* 97 */ array(12, 15, 55, ),
        /* 98 */ array(13, 19, 22, ),
        /* 99 */ array(16, 17, 54, ),
        /* 100 */ array(13, 19, 45, ),
        /* 101 */ array(13, 19, 22, ),
        /* 102 */ array(14, 15, ),
        /* 103 */ array(12, 15, ),
        /* 104 */ array(12, 15, ),
        /* 105 */ array(17, 54, ),
        /* 106 */ array(12, 15, ),
        /* 107 */ array(12, 15, ),
        /* 108 */ array(12, 15, ),
        /* 109 */ array(12, 15, ),
        /* 110 */ array(12, 15, ),
        /* 111 */ array(12, 15, ),
        /* 112 */ array(12, 15, ),
        /* 113 */ array(12, 15, ),
        /* 114 */ array(14, 15, ),
        /* 115 */ array(12, 15, ),
        /* 116 */ array(12, 15, ),
        /* 117 */ array(12, 15, ),
        /* 118 */ array(19, ),
        /* 119 */ array(19, ),
        /* 120 */ array(17, ),
        /* 121 */ array(19, ),
        /* 122 */ array(17, ),
        /* 123 */ array(14, ),
        /* 124 */ array(19, ),
        /* 125 */ array(12, 13, 15, 27, ),
        /* 126 */ array(12, 13, 15, 27, ),
        /* 127 */ array(12, 15, 16, ),
        /* 128 */ array(12, 14, 15, ),
        /* 129 */ array(12, 13, 15, ),
        /* 130 */ array(12, 15, 55, ),
        /* 131 */ array(12, 13, 15, ),
        /* 132 */ array(13, 19, ),
        /* 133 */ array(13, 19, ),
        /* 134 */ array(13, 19, ),
        /* 135 */ array(13, 19, ),
        /* 136 */ array(52, 57, ),
        /* 137 */ array(12, 46, ),
        /* 138 */ array(52, 57, ),
        /* 139 */ array(13, 19, ),
        /* 140 */ array(13, 19, ),
        /* 141 */ array(13, 19, ),
        /* 142 */ array(13, 19, ),
        /* 143 */ array(13, 19, ),
        /* 144 */ array(52, 57, ),
        /* 145 */ array(13, 19, ),
        /* 146 */ array(52, 57, ),
        /* 147 */ array(13, 19, ),
        /* 148 */ array(13, 19, ),
        /* 149 */ array(13, 19, ),
        /* 150 */ array(13, 19, ),
        /* 151 */ array(13, 19, ),
        /* 152 */ array(13, 19, ),
        /* 153 */ array(52, 57, ),
        /* 154 */ array(19, ),
        /* 155 */ array(46, ),
        /* 156 */ array(17, ),
        /* 157 */ array(17, ),
        /* 158 */ array(10, ),
        /* 159 */ array(14, ),
        /* 160 */ array(2, ),
        /* 161 */ array(17, ),
        /* 162 */ array(19, ),
        /* 163 */ array(),
        /* 164 */ array(),
        /* 165 */ array(),
        /* 166 */ array(),
        /* 167 */ array(),
        /* 168 */ array(),
        /* 169 */ array(46, 52, 54, 58, ),
        /* 170 */ array(12, 14, 15, 29, ),
        /* 171 */ array(13, 19, 46, 54, ),
        /* 172 */ array(16, 26, 46, 54, ),
        /* 173 */ array(13, 19, 45, ),
        /* 174 */ array(27, 46, 54, ),
        /* 175 */ array(15, 55, ),
        /* 176 */ array(46, 54, ),
        /* 177 */ array(27, 45, ),
        /* 178 */ array(46, 54, ),
        /* 179 */ array(15, 29, ),
        /* 180 */ array(16, 52, ),
        /* 181 */ array(13, 45, ),
        /* 182 */ array(2, 16, ),
        /* 183 */ array(21, 30, ),
        /* 184 */ array(30, 58, ),
        /* 185 */ array(22, 72, ),
        /* 186 */ array(26, ),
        /* 187 */ array(14, ),
        /* 188 */ array(14, ),
        /* 189 */ array(15, ),
        /* 190 */ array(26, ),
        /* 191 */ array(15, ),
        /* 192 */ array(15, ),
        /* 193 */ array(47, ),
        /* 194 */ array(14, ),
        /* 195 */ array(14, ),
        /* 196 */ array(15, ),
        /* 197 */ array(14, ),
        /* 198 */ array(58, ),
        /* 199 */ array(13, ),
        /* 200 */ array(15, ),
        /* 201 */ array(56, ),
        /* 202 */ array(19, ),
        /* 203 */ array(56, ),
        /* 204 */ array(29, ),
        /* 205 */ array(19, ),
        /* 206 */ array(15, ),
        /* 207 */ array(13, ),
        /* 208 */ array(47, ),
        /* 209 */ array(15, ),
        /* 210 */ array(47, ),
        /* 211 */ array(46, ),
        /* 212 */ array(16, ),
        /* 213 */ array(48, ),
        /* 214 */ array(2, ),
        /* 215 */ array(52, ),
        /* 216 */ array(23, ),
        /* 217 */ array(46, ),
        /* 218 */ array(13, ),
        /* 219 */ array(22, ),
        /* 220 */ array(16, ),
        /* 221 */ array(29, ),
        /* 222 */ array(45, ),
        /* 223 */ array(15, ),
        /* 224 */ array(15, ),
        /* 225 */ array(),
        /* 226 */ array(),
        /* 227 */ array(),
        /* 228 */ array(),
        /* 229 */ array(),
        /* 230 */ array(),
        /* 231 */ array(),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
);
    static public $yy_default = array(
 /*     0 */   544,  527,  544,  500,  544,  544,  544,  544,  500,  544,
 /*    10 */   544,  500,  500,  544,  544,  544,  544,  544,  544,  544,
 /*    20 */   544,  544,  544,  544,  544,  544,  544,  544,  544,  544,
 /*    30 */   544,  544,  544,  544,  544,  544,  544,  544,  544,  544,
 /*    40 */   544,  544,  544,  544,  544,  544,  544,  544,  544,  544,
 /*    50 */   414,  544,  414,  414,  544,  544,  544,  544,  544,  499,
 /*    60 */   544,  544,  544,  544,  544,  544,  544,  399,  444,  528,
 /*    70 */   420,  416,  435,  443,  436,  529,  423,  431,  447,  439,
 /*    80 */   440,  434,  530,  360,  544,  458,  544,  544,  506,  414,
 /*    90 */   414,  414,  414,  544,  544,  473,  544,  473,  448,  466,
 /*   100 */   424,  448,  544,  544,  544,  466,  473,  544,  544,  544,
 /*   110 */   544,  544,  544,  544,  544,  544,  544,  544,  414,  414,
 /*   120 */   503,  414,  466,  544,  414,  544,  544,  544,  544,  544,
 /*   130 */   474,  544,  544,  544,  544,  544,  490,  473,  493,  544,
 /*   140 */   544,  544,  544,  544,  492,  544,  491,  544,  544,  544,
 /*   150 */   544,  544,  544,  471,  543,  473,  507,  504,  374,  544,
 /*   160 */   430,  487,  543,  509,  473,  509,  509,  473,  509,  458,
 /*   170 */   544,  458,  419,  424,  458,  544,  445,  424,  458,  544,
 /*   180 */   454,  424,  485,  544,  544,  448,  544,  544,  544,  544,
 /*   190 */   544,  544,  544,  544,  544,  544,  544,  544,  544,  544,
 /*   200 */   544,  544,  544,  544,  544,  544,  544,  544,  544,  544,
 /*   210 */   544,  485,  419,  460,  485,  454,  421,  505,  544,  448,
 /*   220 */   544,  456,  424,  544,  544,  481,  470,  482,  401,  402,
 /*   230 */   368,  426,  480,  479,  367,  366,  381,  483,  363,  362,
 /*   240 */   497,  361,  418,  476,  380,  397,  365,  494,  364,  469,
 /*   250 */   460,  378,  486,  400,  542,  411,  442,  427,  373,  407,
 /*   260 */   406,  477,  375,  377,  422,  372,  369,  495,  428,  478,
 /*   270 */   457,  376,  446,  370,  511,  371,  510,  496,  441,  379,
 /*   280 */   540,  437,  382,  538,  413,  508,  450,  449,  452,  410,
 /*   290 */   383,  386,  467,  387,  385,  409,  539,  425,  384,  438,
 /*   300 */   451,  517,  518,  519,  516,  515,  512,  513,  514,  520,
 /*   310 */   521,  501,  489,  453,  468,  465,  522,  523,  429,  408,
 /*   320 */   388,  535,  537,  502,  536,  463,  531,  532,  533,  541,
 /*   330 */   534,  396,  432,  412,  525,  526,  455,  433,  524,  394,
 /*   340 */   461,  389,  390,  488,  404,  472,  485,  484,  405,  403,
 /*   350 */   464,  462,  395,  398,  475,  393,  391,  392,  459,  498,
);
    const YYNOCODE = 116;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 360;
    const YYNRULE = 184;
    const YYERRORSYMBOL = 74;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array( 
  '$',             'VERT',          'COLON',         'COMMENT',     
  'PHPSTARTTAG',   'PHPENDTAG',     'FAKEPHPSTARTTAG',  'XMLTAG',      
  'OTHER',         'LITERALSTART',  'LITERALEND',    'LITERAL',     
  'LDEL',          'RDEL',          'DOLLAR',        'ID',          
  'EQUAL',         'PTR',           'LDELIF',        'SPACE',       
  'LDELFOR',       'SEMICOLON',     'INCDEC',        'TO',          
  'STEP',          'LDELFOREACH',   'AS',            'APTR',        
  'LDELSLASH',     'INTEGER',       'COMMA',         'MATH',        
  'UNIMATH',       'ANDSYM',        'ISIN',          'ISDIVBY',     
  'ISNOTDIVBY',    'ISEVEN',        'ISNOTEVEN',     'ISEVENBY',    
  'ISNOTEVENBY',   'ISODD',         'ISNOTODD',      'ISODDBY',     
  'ISNOTODDBY',    'INSTANCEOF',    'OPENP',         'CLOSEP',      
  'QMARK',         'NOT',           'TYPECAST',      'HEX',         
  'DOT',           'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',          
  'HATCH',         'OPENB',         'CLOSEB',        'EQUALS',      
  'NOTEQUALS',     'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',
  'LESSEQUAL',     'IDENTITY',      'NONEIDENTITY',  'MOD',         
  'LAND',          'LOR',           'LXOR',          'QUOTE',       
  'BACKTICK',      'DOLLARID',      'error',         'start',       
  'template',      'template_element',  'smartytag',     'literal',     
  'literal_elements',  'literal_element',  'value',         'attributes',  
  'variable',      'expr',          'ternary',       'varindexed',  
  'modifier',      'modparameters',  'statement',     'statements',  
  'optspace',      'varvar',        'foraction',     'array',       
  'attribute',     'ifcond',        'lop',           'function',    
  'doublequoted_with_quotes',  'static_class_access',  'object',        'arrayindex',  
  'indexdef',      'varvarele',     'objectchain',   'objectelement',
  'method',        'params',        'modparameter',  'arrayelements',
  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template_element ::= smartytag",
 /*   4 */ "template_element ::= COMMENT",
 /*   5 */ "template_element ::= literal",
 /*   6 */ "template_element ::= PHPSTARTTAG",
 /*   7 */ "template_element ::= PHPENDTAG",
 /*   8 */ "template_element ::= FAKEPHPSTARTTAG",
 /*   9 */ "template_element ::= XMLTAG",
 /*  10 */ "template_element ::= OTHER",
 /*  11 */ "literal ::= LITERALSTART LITERALEND",
 /*  12 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  13 */ "literal_elements ::= literal_elements literal_element",
 /*  14 */ "literal_elements ::=",
 /*  15 */ "literal_element ::= literal",
 /*  16 */ "literal_element ::= LITERAL",
 /*  17 */ "literal_element ::= PHPSTARTTAG",
 /*  18 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  19 */ "literal_element ::= PHPENDTAG",
 /*  20 */ "smartytag ::= LDEL value RDEL",
 /*  21 */ "smartytag ::= LDEL value attributes RDEL",
 /*  22 */ "smartytag ::= LDEL variable attributes RDEL",
 /*  23 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  24 */ "smartytag ::= LDEL ternary attributes RDEL",
 /*  25 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  26 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  27 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  28 */ "smartytag ::= LDEL DOLLAR ID EQUAL ternary attributes RDEL",
 /*  29 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  30 */ "smartytag ::= LDEL varindexed EQUAL ternary attributes RDEL",
 /*  31 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  32 */ "smartytag ::= LDEL ID RDEL",
 /*  33 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  34 */ "smartytag ::= LDEL ID modifier modparameters attributes RDEL",
 /*  35 */ "smartytag ::= LDEL ID PTR ID modifier modparameters attributes RDEL",
 /*  36 */ "smartytag ::= LDELIF SPACE expr RDEL",
 /*  37 */ "smartytag ::= LDELIF SPACE statement RDEL",
 /*  38 */ "smartytag ::= LDELFOR SPACE statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction RDEL",
 /*  39 */ "foraction ::= EQUAL expr",
 /*  40 */ "foraction ::= INCDEC",
 /*  41 */ "smartytag ::= LDELFOR SPACE statement TO expr attributes RDEL",
 /*  42 */ "smartytag ::= LDELFOR SPACE statement TO expr STEP expr RDEL",
 /*  43 */ "smartytag ::= LDELFOREACH attributes RDEL",
 /*  44 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar RDEL",
 /*  45 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  46 */ "smartytag ::= LDELFOREACH SPACE array AS DOLLAR varvar RDEL",
 /*  47 */ "smartytag ::= LDELFOREACH SPACE array AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  48 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  49 */ "smartytag ::= LDELSLASH ID attributes RDEL",
 /*  50 */ "smartytag ::= LDELSLASH ID modifier modparameters attributes RDEL",
 /*  51 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  52 */ "attributes ::= attributes attribute",
 /*  53 */ "attributes ::= attribute",
 /*  54 */ "attributes ::=",
 /*  55 */ "attribute ::= SPACE ID EQUAL ID",
 /*  56 */ "attribute ::= SPACE ID EQUAL expr",
 /*  57 */ "attribute ::= SPACE ID EQUAL value",
 /*  58 */ "attribute ::= SPACE ID EQUAL ternary",
 /*  59 */ "attribute ::= SPACE ID",
 /*  60 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  61 */ "statements ::= statement",
 /*  62 */ "statements ::= statements COMMA statement",
 /*  63 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  64 */ "expr ::= value",
 /*  65 */ "expr ::= DOLLAR ID COLON ID",
 /*  66 */ "expr ::= expr MATH value",
 /*  67 */ "expr ::= expr UNIMATH value",
 /*  68 */ "expr ::= expr ANDSYM value",
 /*  69 */ "expr ::= array",
 /*  70 */ "expr ::= expr modifier modparameters",
 /*  71 */ "expr ::= expr ifcond expr",
 /*  72 */ "expr ::= expr ISIN array",
 /*  73 */ "expr ::= expr ISIN value",
 /*  74 */ "expr ::= expr lop expr",
 /*  75 */ "expr ::= expr ISDIVBY expr",
 /*  76 */ "expr ::= expr ISNOTDIVBY expr",
 /*  77 */ "expr ::= expr ISEVEN",
 /*  78 */ "expr ::= expr ISNOTEVEN",
 /*  79 */ "expr ::= expr ISEVENBY expr",
 /*  80 */ "expr ::= expr ISNOTEVENBY expr",
 /*  81 */ "expr ::= expr ISODD",
 /*  82 */ "expr ::= expr ISNOTODD",
 /*  83 */ "expr ::= expr ISODDBY expr",
 /*  84 */ "expr ::= expr ISNOTODDBY expr",
 /*  85 */ "expr ::= value INSTANCEOF ID",
 /*  86 */ "expr ::= value INSTANCEOF value",
 /*  87 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /*  88 */ "value ::= variable",
 /*  89 */ "value ::= UNIMATH value",
 /*  90 */ "value ::= NOT value",
 /*  91 */ "value ::= TYPECAST value",
 /*  92 */ "value ::= variable INCDEC",
 /*  93 */ "value ::= HEX",
 /*  94 */ "value ::= INTEGER",
 /*  95 */ "value ::= INTEGER DOT INTEGER",
 /*  96 */ "value ::= INTEGER DOT",
 /*  97 */ "value ::= DOT INTEGER",
 /*  98 */ "value ::= ID",
 /*  99 */ "value ::= function",
 /* 100 */ "value ::= OPENP expr CLOSEP",
 /* 101 */ "value ::= SINGLEQUOTESTRING",
 /* 102 */ "value ::= doublequoted_with_quotes",
 /* 103 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 104 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 105 */ "value ::= smartytag",
 /* 106 */ "variable ::= varindexed",
 /* 107 */ "variable ::= DOLLAR varvar AT ID",
 /* 108 */ "variable ::= object",
 /* 109 */ "variable ::= HATCH ID HATCH",
 /* 110 */ "variable ::= HATCH variable HATCH",
 /* 111 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 112 */ "arrayindex ::= arrayindex indexdef",
 /* 113 */ "arrayindex ::=",
 /* 114 */ "indexdef ::= DOT DOLLAR varvar",
 /* 115 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 116 */ "indexdef ::= DOT ID",
 /* 117 */ "indexdef ::= DOT INTEGER",
 /* 118 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 119 */ "indexdef ::= OPENB ID CLOSEB",
 /* 120 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 121 */ "indexdef ::= OPENB expr CLOSEB",
 /* 122 */ "indexdef ::= OPENB CLOSEB",
 /* 123 */ "varvar ::= varvarele",
 /* 124 */ "varvar ::= varvar varvarele",
 /* 125 */ "varvarele ::= ID",
 /* 126 */ "varvarele ::= LDEL expr RDEL",
 /* 127 */ "object ::= varindexed objectchain",
 /* 128 */ "objectchain ::= objectelement",
 /* 129 */ "objectchain ::= objectchain objectelement",
 /* 130 */ "objectelement ::= PTR ID arrayindex",
 /* 131 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 132 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 133 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 134 */ "objectelement ::= PTR method",
 /* 135 */ "function ::= ID OPENP params CLOSEP",
 /* 136 */ "method ::= ID OPENP params CLOSEP",
 /* 137 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 138 */ "params ::= expr COMMA params",
 /* 139 */ "params ::= expr",
 /* 140 */ "params ::=",
 /* 141 */ "modifier ::= VERT AT ID",
 /* 142 */ "modifier ::= VERT ID",
 /* 143 */ "static_class_access ::= method",
 /* 144 */ "static_class_access ::= method objectchain",
 /* 145 */ "static_class_access ::= ID",
 /* 146 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 147 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 148 */ "modparameters ::= modparameters modparameter",
 /* 149 */ "modparameters ::=",
 /* 150 */ "modparameter ::= COLON value",
 /* 151 */ "modparameter ::= COLON array",
 /* 152 */ "ifcond ::= EQUALS",
 /* 153 */ "ifcond ::= NOTEQUALS",
 /* 154 */ "ifcond ::= GREATERTHAN",
 /* 155 */ "ifcond ::= LESSTHAN",
 /* 156 */ "ifcond ::= GREATEREQUAL",
 /* 157 */ "ifcond ::= LESSEQUAL",
 /* 158 */ "ifcond ::= IDENTITY",
 /* 159 */ "ifcond ::= NONEIDENTITY",
 /* 160 */ "ifcond ::= MOD",
 /* 161 */ "lop ::= LAND",
 /* 162 */ "lop ::= LOR",
 /* 163 */ "lop ::= LXOR",
 /* 164 */ "array ::= OPENB arrayelements CLOSEB",
 /* 165 */ "arrayelements ::= arrayelement",
 /* 166 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 167 */ "arrayelements ::=",
 /* 168 */ "arrayelement ::= value APTR expr",
 /* 169 */ "arrayelement ::= ID APTR expr",
 /* 170 */ "arrayelement ::= expr",
 /* 171 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 172 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 173 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 174 */ "doublequoted ::= doublequotedcontent",
 /* 175 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 176 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 177 */ "doublequotedcontent ::= DOLLARID",
 /* 178 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 179 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 180 */ "doublequotedcontent ::= smartytag",
 /* 181 */ "doublequotedcontent ::= OTHER",
 /* 182 */ "optspace ::= SPACE",
 /* 183 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 80 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1579 "smarty_internal_templateparser.php"
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 75, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 2 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 2 ),
  array( 'lhs' => 79, 'rhs' => 3 ),
  array( 'lhs' => 80, 'rhs' => 2 ),
  array( 'lhs' => 80, 'rhs' => 0 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 3 ),
  array( 'lhs' => 78, 'rhs' => 4 ),
  array( 'lhs' => 78, 'rhs' => 4 ),
  array( 'lhs' => 78, 'rhs' => 4 ),
  array( 'lhs' => 78, 'rhs' => 4 ),
  array( 'lhs' => 78, 'rhs' => 6 ),
  array( 'lhs' => 78, 'rhs' => 6 ),
  array( 'lhs' => 78, 'rhs' => 7 ),
  array( 'lhs' => 78, 'rhs' => 7 ),
  array( 'lhs' => 78, 'rhs' => 6 ),
  array( 'lhs' => 78, 'rhs' => 6 ),
  array( 'lhs' => 78, 'rhs' => 4 ),
  array( 'lhs' => 78, 'rhs' => 3 ),
  array( 'lhs' => 78, 'rhs' => 6 ),
  array( 'lhs' => 78, 'rhs' => 6 ),
  array( 'lhs' => 78, 'rhs' => 8 ),
  array( 'lhs' => 78, 'rhs' => 4 ),
  array( 'lhs' => 78, 'rhs' => 4 ),
  array( 'lhs' => 78, 'rhs' => 12 ),
  array( 'lhs' => 94, 'rhs' => 2 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 7 ),
  array( 'lhs' => 78, 'rhs' => 8 ),
  array( 'lhs' => 78, 'rhs' => 3 ),
  array( 'lhs' => 78, 'rhs' => 7 ),
  array( 'lhs' => 78, 'rhs' => 10 ),
  array( 'lhs' => 78, 'rhs' => 7 ),
  array( 'lhs' => 78, 'rhs' => 10 ),
  array( 'lhs' => 78, 'rhs' => 3 ),
  array( 'lhs' => 78, 'rhs' => 4 ),
  array( 'lhs' => 78, 'rhs' => 6 ),
  array( 'lhs' => 78, 'rhs' => 5 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 0 ),
  array( 'lhs' => 96, 'rhs' => 4 ),
  array( 'lhs' => 96, 'rhs' => 4 ),
  array( 'lhs' => 96, 'rhs' => 4 ),
  array( 'lhs' => 96, 'rhs' => 4 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 4 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 2 ),
  array( 'lhs' => 82, 'rhs' => 2 ),
  array( 'lhs' => 82, 'rhs' => 2 ),
  array( 'lhs' => 82, 'rhs' => 2 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 2 ),
  array( 'lhs' => 82, 'rhs' => 2 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 4 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 103, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 0 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 5 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 4 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 5 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 102, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 4 ),
  array( 'lhs' => 107, 'rhs' => 5 ),
  array( 'lhs' => 107, 'rhs' => 6 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 4 ),
  array( 'lhs' => 108, 'rhs' => 4 ),
  array( 'lhs' => 108, 'rhs' => 5 ),
  array( 'lhs' => 109, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 0 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 2 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 0 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 1 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 0 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 113, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        5 => 0,
        15 => 0,
        16 => 0,
        64 => 0,
        88 => 0,
        93 => 0,
        94 => 0,
        99 => 0,
        101 => 0,
        102 => 0,
        108 => 0,
        143 => 0,
        165 => 0,
        1 => 1,
        2 => 2,
        3 => 3,
        4 => 4,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        14 => 11,
        12 => 12,
        13 => 13,
        89 => 13,
        91 => 13,
        92 => 13,
        144 => 13,
        17 => 17,
        18 => 17,
        19 => 19,
        20 => 20,
        21 => 21,
        22 => 21,
        23 => 21,
        24 => 21,
        25 => 25,
        26 => 25,
        27 => 27,
        28 => 27,
        29 => 29,
        30 => 29,
        31 => 31,
        32 => 32,
        33 => 33,
        34 => 34,
        35 => 35,
        36 => 36,
        37 => 36,
        38 => 38,
        39 => 39,
        40 => 40,
        53 => 40,
        139 => 40,
        145 => 40,
        170 => 40,
        41 => 41,
        42 => 42,
        43 => 43,
        44 => 44,
        45 => 45,
        46 => 46,
        47 => 47,
        48 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 56,
        58 => 56,
        59 => 59,
        60 => 60,
        61 => 61,
        62 => 62,
        63 => 63,
        65 => 65,
        66 => 66,
        67 => 66,
        68 => 66,
        69 => 69,
        123 => 69,
        182 => 69,
        70 => 70,
        71 => 71,
        74 => 71,
        85 => 71,
        72 => 72,
        73 => 73,
        75 => 75,
        76 => 76,
        77 => 77,
        82 => 77,
        78 => 78,
        81 => 78,
        79 => 79,
        84 => 79,
        80 => 80,
        83 => 80,
        86 => 86,
        87 => 87,
        90 => 90,
        95 => 95,
        96 => 96,
        97 => 97,
        98 => 98,
        100 => 100,
        103 => 103,
        104 => 104,
        105 => 105,
        106 => 106,
        107 => 107,
        109 => 109,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        149 => 113,
        114 => 114,
        115 => 115,
        116 => 116,
        117 => 117,
        118 => 118,
        121 => 118,
        119 => 119,
        120 => 120,
        122 => 122,
        183 => 122,
        124 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        134 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        138 => 138,
        140 => 140,
        141 => 141,
        142 => 141,
        146 => 146,
        147 => 147,
        148 => 148,
        150 => 150,
        151 => 150,
        152 => 152,
        153 => 153,
        154 => 154,
        155 => 155,
        156 => 156,
        157 => 157,
        158 => 158,
        159 => 159,
        160 => 160,
        161 => 161,
        162 => 162,
        163 => 163,
        164 => 164,
        166 => 166,
        167 => 167,
        168 => 168,
        169 => 169,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 175,
        178 => 175,
        177 => 177,
        179 => 179,
        180 => 180,
        181 => 181,
    );
#line 91 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 1974 "smarty_internal_templateparser.php"
#line 97 "smarty_internal_templateparser.y"
    function yy_r1(){if ($this->template->extract_code == false) {
                                                  $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
                                               } else {
                                                 // store code in extract buffer
                                                  $this->template->extracted_compiled_code .= $this->yystack[$this->yyidx + 0]->minor;
                                               } 
                                                 }
#line 1983 "smarty_internal_templateparser.php"
#line 105 "smarty_internal_templateparser.y"
    function yy_r2(){if ($this->template->extract_code == false) {
                                                             $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
                                                           } else {
                                                             // store code in extract buffer
                                                             $this->template->extracted_compiled_code .= $this->yystack[$this->yyidx + 0]->minor;
                                                             $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
                                                           } 
                                                              }
#line 1993 "smarty_internal_templateparser.php"
#line 118 "smarty_internal_templateparser.y"
    function yy_r3(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true);
                                         } else { 
                                           $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
                                         }  
                                         $this->compiler->has_variable_string = false;
                                         $this->block_nesting_level = count($this->compiler->_tag_stack);
                                            }
#line 2005 "smarty_internal_templateparser.php"
#line 130 "smarty_internal_templateparser.y"
    function yy_r4(){ $this->_retvalue = '';    }
#line 2008 "smarty_internal_templateparser.php"
#line 136 "smarty_internal_templateparser.y"
    function yy_r6(){
                                      if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
					                             $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = $this->compiler->processNocacheCode(htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES),false);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = $this->compiler->processNocacheCode('<?php', true);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = '';
                                      }
                                         }
#line 2021 "smarty_internal_templateparser.php"
#line 148 "smarty_internal_templateparser.y"
    function yy_r7(){if ($this->is_xml) {
                                       $this->compiler->tag_nocache = true; 
                                       $this->is_xml = true; 
                                       $this->_retvalue = $this->compiler->processNocacheCode("<?php echo '?>';?>", $this->compiler, true);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
					                             $this->_retvalue = '?<??>>';
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = $this->compiler->processNocacheCode(htmlspecialchars('?>', ENT_QUOTES), false);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = $this->compiler->processNocacheCode('?>', true);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = '';
                                      }
                                         }
#line 2037 "smarty_internal_templateparser.php"
#line 163 "smarty_internal_templateparser.y"
    function yy_r8(){if ($this->lex->strip) {
                                       $this->_retvalue = preg_replace('![\$this->yystack[$this->yyidx + 0]->minor ]*[\r\n]+[\$this->yystack[$this->yyidx + 0]->minor ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));	
                                     } else {
                                       $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);	
                                     }
                                        }
#line 2045 "smarty_internal_templateparser.php"
#line 171 "smarty_internal_templateparser.y"
    function yy_r9(){ $this->compiler->tag_nocache = true; $this->is_xml = true; $this->_retvalue = $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true);    }
#line 2048 "smarty_internal_templateparser.php"
#line 174 "smarty_internal_templateparser.y"
    function yy_r10(){if ($this->lex->strip) {
                                       $this->_retvalue = preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor);	
                                     } else {
                                       $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;	
                                     }
                                        }
#line 2056 "smarty_internal_templateparser.php"
#line 182 "smarty_internal_templateparser.y"
    function yy_r11(){ $this->_retvalue = '';     }
#line 2059 "smarty_internal_templateparser.php"
#line 183 "smarty_internal_templateparser.y"
    function yy_r12(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2062 "smarty_internal_templateparser.php"
#line 185 "smarty_internal_templateparser.y"
    function yy_r13(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2065 "smarty_internal_templateparser.php"
#line 190 "smarty_internal_templateparser.y"
    function yy_r17(){ $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2068 "smarty_internal_templateparser.php"
#line 192 "smarty_internal_templateparser.y"
    function yy_r19(){ $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2071 "smarty_internal_templateparser.php"
#line 200 "smarty_internal_templateparser.y"
    function yy_r20(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array('value'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2074 "smarty_internal_templateparser.php"
#line 201 "smarty_internal_templateparser.y"
    function yy_r21(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2077 "smarty_internal_templateparser.php"
#line 212 "smarty_internal_templateparser.y"
    function yy_r25(){ $this->_retvalue = $this->compiler->compileTag('assign',array('value'=>$this->yystack[$this->yyidx + -1]->minor,'var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'"));    }
#line 2080 "smarty_internal_templateparser.php"
#line 214 "smarty_internal_templateparser.y"
    function yy_r27(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor,'var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'"),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2083 "smarty_internal_templateparser.php"
#line 216 "smarty_internal_templateparser.y"
    function yy_r29(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor));    }
#line 2086 "smarty_internal_templateparser.php"
#line 219 "smarty_internal_templateparser.y"
    function yy_r31(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);    }
#line 2089 "smarty_internal_templateparser.php"
#line 220 "smarty_internal_templateparser.y"
    function yy_r32(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());    }
#line 2092 "smarty_internal_templateparser.php"
#line 222 "smarty_internal_templateparser.y"
    function yy_r33(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2095 "smarty_internal_templateparser.php"
#line 224 "smarty_internal_templateparser.y"
    function yy_r34(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                     }
#line 2100 "smarty_internal_templateparser.php"
#line 228 "smarty_internal_templateparser.y"
    function yy_r35(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -4]->minor),$this->yystack[$this->yyidx + -1]->minor)).'<?php echo ';
                                                                                               $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                                }
#line 2105 "smarty_internal_templateparser.php"
#line 232 "smarty_internal_templateparser.y"
    function yy_r36(){ $tag = trim(substr($this->yystack[$this->yyidx + -3]->minor,$this->lex->ldel_length)); $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2108 "smarty_internal_templateparser.php"
#line 235 "smarty_internal_templateparser.y"
    function yy_r38(){
                                                             $this->_retvalue = $this->compiler->compileTag('for',array('start'=>$this->yystack[$this->yyidx + -9]->minor,'ifexp'=>$this->yystack[$this->yyidx + -6]->minor,'varloop'=>$this->yystack[$this->yyidx + -2]->minor,'loop'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2112 "smarty_internal_templateparser.php"
#line 238 "smarty_internal_templateparser.y"
    function yy_r39(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2115 "smarty_internal_templateparser.php"
#line 239 "smarty_internal_templateparser.y"
    function yy_r40(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2118 "smarty_internal_templateparser.php"
#line 240 "smarty_internal_templateparser.y"
    function yy_r41(){ $this->_retvalue = $this->compiler->compileTag('for',array_merge(array('start'=>$this->yystack[$this->yyidx + -4]->minor,'to'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2121 "smarty_internal_templateparser.php"
#line 241 "smarty_internal_templateparser.y"
    function yy_r42(){ $this->_retvalue = $this->compiler->compileTag('for',array('start'=>$this->yystack[$this->yyidx + -5]->minor,'to'=>$this->yystack[$this->yyidx + -3]->minor,'step'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2124 "smarty_internal_templateparser.php"
#line 243 "smarty_internal_templateparser.y"
    function yy_r43(){ $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2127 "smarty_internal_templateparser.php"
#line 245 "smarty_internal_templateparser.y"
    function yy_r44(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2131 "smarty_internal_templateparser.php"
#line 247 "smarty_internal_templateparser.y"
    function yy_r45(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2135 "smarty_internal_templateparser.php"
#line 249 "smarty_internal_templateparser.y"
    function yy_r46(){ 
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2139 "smarty_internal_templateparser.php"
#line 251 "smarty_internal_templateparser.y"
    function yy_r47(){ 
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2143 "smarty_internal_templateparser.php"
#line 255 "smarty_internal_templateparser.y"
    function yy_r48(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());    }
#line 2146 "smarty_internal_templateparser.php"
#line 256 "smarty_internal_templateparser.y"
    function yy_r49(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2149 "smarty_internal_templateparser.php"
#line 257 "smarty_internal_templateparser.y"
    function yy_r50(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                         $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                          }
#line 2154 "smarty_internal_templateparser.php"
#line 261 "smarty_internal_templateparser.y"
    function yy_r51(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2157 "smarty_internal_templateparser.php"
#line 268 "smarty_internal_templateparser.y"
    function yy_r52(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor; $this->_retvalue[key($this->yystack[$this->yyidx + 0]->minor)] = $this->yystack[$this->yyidx + 0]->minor[key($this->yystack[$this->yyidx + 0]->minor)];    }
#line 2160 "smarty_internal_templateparser.php"
#line 272 "smarty_internal_templateparser.y"
    function yy_r54(){ $this->_retvalue = array();    }
#line 2163 "smarty_internal_templateparser.php"
#line 275 "smarty_internal_templateparser.y"
    function yy_r55(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
                                                 } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
                                                 } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
                                                 } else
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");    }
#line 2173 "smarty_internal_templateparser.php"
#line 283 "smarty_internal_templateparser.y"
    function yy_r56(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2176 "smarty_internal_templateparser.php"
#line 286 "smarty_internal_templateparser.y"
    function yy_r59(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor=>'true');    }
#line 2179 "smarty_internal_templateparser.php"
#line 287 "smarty_internal_templateparser.y"
    function yy_r60(){$this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2182 "smarty_internal_templateparser.php"
#line 293 "smarty_internal_templateparser.y"
    function yy_r61(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2185 "smarty_internal_templateparser.php"
#line 294 "smarty_internal_templateparser.y"
    function yy_r62(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2188 "smarty_internal_templateparser.php"
#line 296 "smarty_internal_templateparser.y"
    function yy_r63(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2191 "smarty_internal_templateparser.php"
#line 305 "smarty_internal_templateparser.y"
    function yy_r65(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2194 "smarty_internal_templateparser.php"
#line 307 "smarty_internal_templateparser.y"
    function yy_r66(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2197 "smarty_internal_templateparser.php"
#line 313 "smarty_internal_templateparser.y"
    function yy_r69(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2200 "smarty_internal_templateparser.php"
#line 316 "smarty_internal_templateparser.y"
    function yy_r70(){  $this->_retvalue = $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -1]->minor,'params'=>$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor));     }
#line 2203 "smarty_internal_templateparser.php"
#line 320 "smarty_internal_templateparser.y"
    function yy_r71(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2206 "smarty_internal_templateparser.php"
#line 321 "smarty_internal_templateparser.y"
    function yy_r72(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2209 "smarty_internal_templateparser.php"
#line 322 "smarty_internal_templateparser.y"
    function yy_r73(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2212 "smarty_internal_templateparser.php"
#line 324 "smarty_internal_templateparser.y"
    function yy_r75(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2215 "smarty_internal_templateparser.php"
#line 325 "smarty_internal_templateparser.y"
    function yy_r76(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2218 "smarty_internal_templateparser.php"
#line 326 "smarty_internal_templateparser.y"
    function yy_r77(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2221 "smarty_internal_templateparser.php"
#line 327 "smarty_internal_templateparser.y"
    function yy_r78(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2224 "smarty_internal_templateparser.php"
#line 328 "smarty_internal_templateparser.y"
    function yy_r79(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2227 "smarty_internal_templateparser.php"
#line 329 "smarty_internal_templateparser.y"
    function yy_r80(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2230 "smarty_internal_templateparser.php"
#line 335 "smarty_internal_templateparser.y"
    function yy_r86(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2233 "smarty_internal_templateparser.php"
#line 341 "smarty_internal_templateparser.y"
    function yy_r87(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2236 "smarty_internal_templateparser.php"
#line 348 "smarty_internal_templateparser.y"
    function yy_r90(){ $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2239 "smarty_internal_templateparser.php"
#line 354 "smarty_internal_templateparser.y"
    function yy_r95(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2242 "smarty_internal_templateparser.php"
#line 355 "smarty_internal_templateparser.y"
    function yy_r96(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';     }
#line 2245 "smarty_internal_templateparser.php"
#line 356 "smarty_internal_templateparser.y"
    function yy_r97(){ $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2248 "smarty_internal_templateparser.php"
#line 358 "smarty_internal_templateparser.y"
    function yy_r98(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'true';
                               } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'false';
                               } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'null';
                               } else
                               $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";     }
#line 2258 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r100(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2261 "smarty_internal_templateparser.php"
#line 375 "smarty_internal_templateparser.y"
    function yy_r103(){if (!$this->template->security || $this->smarty->security_handler->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
                                                                  $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor; 
                                                                }    }
#line 2266 "smarty_internal_templateparser.php"
#line 378 "smarty_internal_templateparser.y"
    function yy_r104(){ if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2270 "smarty_internal_templateparser.php"
#line 381 "smarty_internal_templateparser.y"
    function yy_r105(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2273 "smarty_internal_templateparser.php"
#line 390 "smarty_internal_templateparser.y"
    function yy_r106(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
                                      } else {
                                      if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + 0]->minor['var']])) {
                                          $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + 0]->minor['var'] .']->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                         } else {
                                          $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                         }
                                       $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2283 "smarty_internal_templateparser.php"
#line 399 "smarty_internal_templateparser.y"
    function yy_r107(){if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + -2]->minor])) {
                                                  $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 } else {
                                                  $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 }
                                                  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2291 "smarty_internal_templateparser.php"
#line 408 "smarty_internal_templateparser.y"
    function yy_r109(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2294 "smarty_internal_templateparser.php"
#line 409 "smarty_internal_templateparser.y"
    function yy_r110(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2297 "smarty_internal_templateparser.php"
#line 412 "smarty_internal_templateparser.y"
    function yy_r111(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2300 "smarty_internal_templateparser.php"
#line 418 "smarty_internal_templateparser.y"
    function yy_r112(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2303 "smarty_internal_templateparser.php"
#line 420 "smarty_internal_templateparser.y"
    function yy_r113(){return;    }
#line 2306 "smarty_internal_templateparser.php"
#line 424 "smarty_internal_templateparser.y"
    function yy_r114(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor .')->value]'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + 0]->minor', null, true, false)->nocache;    }
#line 2309 "smarty_internal_templateparser.php"
#line 425 "smarty_internal_templateparser.y"
    function yy_r115(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor.']'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2312 "smarty_internal_templateparser.php"
#line 426 "smarty_internal_templateparser.y"
    function yy_r116(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2315 "smarty_internal_templateparser.php"
#line 427 "smarty_internal_templateparser.y"
    function yy_r117(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2318 "smarty_internal_templateparser.php"
#line 428 "smarty_internal_templateparser.y"
    function yy_r118(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2321 "smarty_internal_templateparser.php"
#line 430 "smarty_internal_templateparser.y"
    function yy_r119(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2324 "smarty_internal_templateparser.php"
#line 431 "smarty_internal_templateparser.y"
    function yy_r120(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2327 "smarty_internal_templateparser.php"
#line 435 "smarty_internal_templateparser.y"
    function yy_r122(){$this->_retvalue = '';    }
#line 2330 "smarty_internal_templateparser.php"
#line 443 "smarty_internal_templateparser.y"
    function yy_r124(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2333 "smarty_internal_templateparser.php"
#line 445 "smarty_internal_templateparser.y"
    function yy_r125(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2336 "smarty_internal_templateparser.php"
#line 447 "smarty_internal_templateparser.y"
    function yy_r126(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2339 "smarty_internal_templateparser.php"
#line 452 "smarty_internal_templateparser.y"
    function yy_r127(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2343 "smarty_internal_templateparser.php"
#line 455 "smarty_internal_templateparser.y"
    function yy_r128(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2346 "smarty_internal_templateparser.php"
#line 457 "smarty_internal_templateparser.y"
    function yy_r129(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2349 "smarty_internal_templateparser.php"
#line 459 "smarty_internal_templateparser.y"
    function yy_r130(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2352 "smarty_internal_templateparser.php"
#line 460 "smarty_internal_templateparser.y"
    function yy_r131(){ $this->_retvalue = '->{$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor .')->value'.$this->yystack[$this->yyidx + 0]->minor.'}'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor,"'"), null, true, false)->nocache;    }
#line 2355 "smarty_internal_templateparser.php"
#line 461 "smarty_internal_templateparser.y"
    function yy_r132(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2358 "smarty_internal_templateparser.php"
#line 462 "smarty_internal_templateparser.y"
    function yy_r133(){ $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2361 "smarty_internal_templateparser.php"
#line 464 "smarty_internal_templateparser.y"
    function yy_r134(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2364 "smarty_internal_templateparser.php"
#line 470 "smarty_internal_templateparser.y"
    function yy_r135(){if (!$this->template->security || $this->smarty->security_handler->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if ($this->yystack[$this->yyidx + -3]->minor == 'isset' || $this->yystack[$this->yyidx + -3]->minor == 'empty' || $this->yystack[$this->yyidx + -3]->minor == 'array' || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                    }    }
#line 2373 "smarty_internal_templateparser.php"
#line 481 "smarty_internal_templateparser.y"
    function yy_r136(){ $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";    }
#line 2376 "smarty_internal_templateparser.php"
#line 482 "smarty_internal_templateparser.y"
    function yy_r137(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = '$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2379 "smarty_internal_templateparser.php"
#line 486 "smarty_internal_templateparser.y"
    function yy_r138(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.",".$this->yystack[$this->yyidx + 0]->minor;    }
#line 2382 "smarty_internal_templateparser.php"
#line 490 "smarty_internal_templateparser.y"
    function yy_r140(){ return;    }
#line 2385 "smarty_internal_templateparser.php"
#line 495 "smarty_internal_templateparser.y"
    function yy_r141(){ $this->_retvalue =  $this->yystack[$this->yyidx + 0]->minor;    }
#line 2388 "smarty_internal_templateparser.php"
#line 505 "smarty_internal_templateparser.y"
    function yy_r146(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2391 "smarty_internal_templateparser.php"
#line 507 "smarty_internal_templateparser.y"
    function yy_r147(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2394 "smarty_internal_templateparser.php"
#line 518 "smarty_internal_templateparser.y"
    function yy_r148(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2397 "smarty_internal_templateparser.php"
#line 522 "smarty_internal_templateparser.y"
    function yy_r150(){$this->_retvalue = ','.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2400 "smarty_internal_templateparser.php"
#line 526 "smarty_internal_templateparser.y"
    function yy_r152(){$this->_retvalue = '==';    }
#line 2403 "smarty_internal_templateparser.php"
#line 527 "smarty_internal_templateparser.y"
    function yy_r153(){$this->_retvalue = '!=';    }
#line 2406 "smarty_internal_templateparser.php"
#line 528 "smarty_internal_templateparser.y"
    function yy_r154(){$this->_retvalue = '>';    }
#line 2409 "smarty_internal_templateparser.php"
#line 529 "smarty_internal_templateparser.y"
    function yy_r155(){$this->_retvalue = '<';    }
#line 2412 "smarty_internal_templateparser.php"
#line 530 "smarty_internal_templateparser.y"
    function yy_r156(){$this->_retvalue = '>=';    }
#line 2415 "smarty_internal_templateparser.php"
#line 531 "smarty_internal_templateparser.y"
    function yy_r157(){$this->_retvalue = '<=';    }
#line 2418 "smarty_internal_templateparser.php"
#line 532 "smarty_internal_templateparser.y"
    function yy_r158(){$this->_retvalue = '===';    }
#line 2421 "smarty_internal_templateparser.php"
#line 533 "smarty_internal_templateparser.y"
    function yy_r159(){$this->_retvalue = '!==';    }
#line 2424 "smarty_internal_templateparser.php"
#line 534 "smarty_internal_templateparser.y"
    function yy_r160(){$this->_retvalue = '%';    }
#line 2427 "smarty_internal_templateparser.php"
#line 536 "smarty_internal_templateparser.y"
    function yy_r161(){$this->_retvalue = '&&';    }
#line 2430 "smarty_internal_templateparser.php"
#line 537 "smarty_internal_templateparser.y"
    function yy_r162(){$this->_retvalue = '||';    }
#line 2433 "smarty_internal_templateparser.php"
#line 538 "smarty_internal_templateparser.y"
    function yy_r163(){$this->_retvalue = ' XOR ';    }
#line 2436 "smarty_internal_templateparser.php"
#line 543 "smarty_internal_templateparser.y"
    function yy_r164(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2439 "smarty_internal_templateparser.php"
#line 545 "smarty_internal_templateparser.y"
    function yy_r166(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2442 "smarty_internal_templateparser.php"
#line 546 "smarty_internal_templateparser.y"
    function yy_r167(){ return;     }
#line 2445 "smarty_internal_templateparser.php"
#line 547 "smarty_internal_templateparser.y"
    function yy_r168(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2448 "smarty_internal_templateparser.php"
#line 548 "smarty_internal_templateparser.y"
    function yy_r169(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2451 "smarty_internal_templateparser.php"
#line 555 "smarty_internal_templateparser.y"
    function yy_r171(){ $this->_retvalue = "''";     }
#line 2454 "smarty_internal_templateparser.php"
#line 556 "smarty_internal_templateparser.y"
    function yy_r172(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();     }
#line 2457 "smarty_internal_templateparser.php"
#line 558 "smarty_internal_templateparser.y"
    function yy_r173(){ $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor); $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2460 "smarty_internal_templateparser.php"
#line 559 "smarty_internal_templateparser.y"
    function yy_r174(){ $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2463 "smarty_internal_templateparser.php"
#line 561 "smarty_internal_templateparser.y"
    function yy_r175(){ $this->_retvalue = new _smarty_code($this, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2466 "smarty_internal_templateparser.php"
#line 563 "smarty_internal_templateparser.y"
    function yy_r177(){if (isset($this->compiler->local_var["'".substr($this->yystack[$this->yyidx + 0]->minor,1)."'"])) {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
                                                      } else {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->value');
                                                      }
                                                      $this->compiler->tag_nocache = $this->compiler->tag_nocache | $this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"), null, true, false)->nocache;
      }
#line 2475 "smarty_internal_templateparser.php"
#line 571 "smarty_internal_templateparser.y"
    function yy_r179(){ $this->_retvalue = new _smarty_code($this, '('.$this->yystack[$this->yyidx + -1]->minor.')');     }
#line 2478 "smarty_internal_templateparser.php"
#line 572 "smarty_internal_templateparser.y"
    function yy_r180(){
   $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
      }
#line 2483 "smarty_internal_templateparser.php"
#line 575 "smarty_internal_templateparser.y"
    function yy_r181(){ $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2486 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 73 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2549 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 65 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2567 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>